/*
 * Decompiled with CFR 0.152.
 */
package lotr.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRBannerProtection;
import lotr.common.LOTRConfig;
import lotr.common.LOTRDate;
import lotr.common.LOTRDimension;
import lotr.common.LOTRGreyWandererTracker;
import lotr.common.LOTRInterModComms;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRNetHandlerPlayServer;
import lotr.common.LOTRReflection;
import lotr.common.LOTRTime;
import lotr.common.block.LOTRBlockPortal;
import lotr.common.entity.item.LOTREntityPortal;
import lotr.common.fac.LOTRFaction;
import lotr.common.fac.LOTRFactionBounties;
import lotr.common.fac.LOTRFactionRelations;
import lotr.common.fellowship.LOTRFellowshipData;
import lotr.common.item.LOTRItemStructureSpawner;
import lotr.common.world.LOTRTeleporter;
import lotr.common.world.LOTRUtumnoLevel;
import lotr.common.world.LOTRWorldInfo;
import lotr.common.world.LOTRWorldProvider;
import lotr.common.world.LOTRWorldProviderUtumno;
import lotr.common.world.biome.LOTRBiomeGenGorgoroth;
import lotr.common.world.biome.variant.LOTRBiomeVariantStorage;
import lotr.common.world.map.LOTRConquestGrid;
import lotr.common.world.spawning.LOTREventSpawner;
import lotr.common.world.spawning.LOTRSpawnerNPCs;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemEditableBook;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;

public class LOTRTickHandlerServer {
    public static HashMap playersInPortals = new HashMap();
    public static HashMap playersInElvenPortals = new HashMap();
    public static HashMap playersInMorgulPortals = new HashMap();
    private int fireworkDisplay;

    public LOTRTickHandlerServer() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (world.field_72995_K) {
            return;
        }
        if (event.phase == TickEvent.Phase.START && world == DimensionManager.getWorld((int)0)) {
            World overworld = world;
            if (LOTRLevelData.needsLoad) {
                LOTRLevelData.load();
            }
            if (LOTRTime.needsLoad) {
                LOTRTime.load();
            }
            if (LOTRFellowshipData.needsLoad) {
                LOTRFellowshipData.loadAll();
            }
            if (LOTRFactionBounties.needsLoad) {
                LOTRFactionBounties.loadAll();
            }
            if (LOTRFactionRelations.needsLoad) {
                LOTRFactionRelations.load();
            }
            if (LOTRConquestGrid.needsLoad) {
                LOTRConquestGrid.loadAllZones();
            }
            for (WorldServer dimWorld : MinecraftServer.func_71276_C().field_71305_c) {
                WorldInfo prevWorldInfo;
                if (!(dimWorld.field_73011_w instanceof LOTRWorldProvider) || (prevWorldInfo = dimWorld.func_72912_H()).getClass() == LOTRWorldInfo.class) continue;
                LOTRWorldInfo newWorldInfo = new LOTRWorldInfo(overworld.func_72912_H());
                newWorldInfo.func_76062_a(prevWorldInfo.func_76065_j());
                LOTRReflection.setWorldInfo((World)dimWorld, (WorldInfo)newWorldInfo);
                FMLLog.info((String)"LOTR: Successfully replaced world info in %s", (Object[])new Object[]{LOTRDimension.getCurrentDimensionWithFallback((World)dimWorld).dimensionName});
            }
            LOTRBannerProtection.updateWarningCooldowns();
            LOTRInterModComms.update();
        }
        if (event.phase == TickEvent.Phase.END) {
            if (world == DimensionManager.getWorld((int)0)) {
                if (LOTRLevelData.anyDataNeedsSave()) {
                    LOTRLevelData.save();
                }
                if (LOTRFellowshipData.anyDataNeedsSave()) {
                    LOTRFellowshipData.saveAll();
                }
                LOTRFactionBounties.updateAll();
                if (LOTRFactionBounties.anyDataNeedsSave()) {
                    LOTRFactionBounties.saveAll();
                }
                if (LOTRFactionRelations.needsSave()) {
                    LOTRFactionRelations.save();
                }
                if (LOTRConquestGrid.anyChangedZones()) {
                    LOTRConquestGrid.saveChangedZones();
                }
                if (world.func_82737_E() % 600L == 0L) {
                    LOTRLevelData.save();
                    LOTRLevelData.saveAndClearUnusedPlayerData();
                    LOTRFellowshipData.saveAll();
                    LOTRFellowshipData.saveAndClearUnusedFellowships();
                    LOTRFactionBounties.saveAll();
                    LOTRFactionRelations.save();
                }
                if (LOTRItemStructureSpawner.lastStructureSpawnTick > 0) {
                    --LOTRItemStructureSpawner.lastStructureSpawnTick;
                }
                int playerDataClearingInterval = LOTRConfig.playerDataClearingInterval;
                playerDataClearingInterval = Math.max(playerDataClearingInterval, 600);
                if (world.func_82737_E() % (long)playerDataClearingInterval == 0L) {
                    LOTRLevelData.saveAndClearUnusedPlayerData();
                }
                if (LOTRItemStructureSpawner.lastStructureSpawnTick > 0) {
                    --LOTRItemStructureSpawner.lastStructureSpawnTick;
                }
                LOTRTime.update();
                LOTRGreyWandererTracker.updateCooldowns();
            }
            if (world == DimensionManager.getWorld((int)LOTRDimension.MIDDLE_EARTH.dimensionID)) {
                LOTRDate.update(world);
                if (LOTRMod.canSpawnMobs(world)) {
                    LOTRSpawnerNPCs.performSpawning(world);
                    LOTREventSpawner.performSpawning(world);
                }
                LOTRConquestGrid.updateZones(world);
                if (!world.field_73010_i.isEmpty()) {
                    if (LOTRMod.isNewYearsDay()) {
                        if (this.fireworkDisplay == 0 && world.field_73012_v.nextInt(4000) == 0) {
                            this.fireworkDisplay = 100 + world.field_73012_v.nextInt(300);
                        }
                        if (this.fireworkDisplay > 0) {
                            --this.fireworkDisplay;
                            if (world.field_73012_v.nextInt(50) == 0) {
                                int launches = 1 + world.field_73012_v.nextInt(7 + world.field_73010_i.size() / 2);
                                int range = 64;
                                for (int l = 0; l < launches; ++l) {
                                    int k;
                                    EntityPlayer entityplayer = (EntityPlayer)world.field_73010_i.get(world.field_73012_v.nextInt(world.field_73010_i.size()));
                                    int i = MathHelper.func_76128_c((double)entityplayer.field_70165_t) + MathHelper.func_76136_a((Random)world.field_73012_v, (int)(-range), (int)range);
                                    if (!world.func_147439_a(i, world.func_72976_f(i, k = MathHelper.func_76128_c((double)entityplayer.field_70161_v) + MathHelper.func_76136_a((Random)world.field_73012_v, (int)(-range), (int)range)) - 1, k).func_149721_r()) continue;
                                    int fireworks = 1 + world.field_73012_v.nextInt(4);
                                    for (int l1 = 0; l1 < fireworks; ++l1) {
                                        int k1;
                                        int j1;
                                        int groupRange = 8;
                                        int i1 = i - world.field_73012_v.nextInt(groupRange) + world.field_73012_v.nextInt(groupRange);
                                        if (!world.func_147439_a(i1, (j1 = world.func_72976_f(i1, k1 = k - world.field_73012_v.nextInt(groupRange) + world.field_73012_v.nextInt(groupRange))) - 1, k1).func_149721_r()) continue;
                                        ItemStack itemstack = new ItemStack(Items.field_151152_bP);
                                        NBTTagCompound itemData = new NBTTagCompound();
                                        NBTTagCompound fireworkData = new NBTTagCompound();
                                        NBTTagList explosionsList = new NBTTagList();
                                        int explosions = 1 + world.field_73012_v.nextInt(3);
                                        for (int l2 = 0; l2 < explosions; ++l2) {
                                            NBTTagCompound explosionData = new NBTTagCompound();
                                            if (world.field_73012_v.nextBoolean()) {
                                                explosionData.func_74757_a("Flicker", true);
                                            }
                                            if (world.field_73012_v.nextBoolean()) {
                                                explosionData.func_74757_a("Trail", true);
                                            }
                                            int[] colors = new int[1 + world.field_73012_v.nextInt(3)];
                                            for (int l3 = 0; l3 < colors.length; ++l3) {
                                                colors[l3] = ItemDye.field_150922_c[world.field_73012_v.nextInt(ItemDye.field_150922_c.length)];
                                            }
                                            explosionData.func_74783_a("Colors", colors);
                                            int effectType = world.field_73012_v.nextInt(5);
                                            if (effectType == 3) {
                                                effectType = 0;
                                            }
                                            explosionData.func_74774_a("Type", (byte)effectType);
                                            explosionsList.func_74742_a((NBTBase)explosionData);
                                        }
                                        fireworkData.func_74782_a("Explosions", (NBTBase)explosionsList);
                                        int flight = 1 + world.field_73012_v.nextInt(3);
                                        fireworkData.func_74774_a("Flight", (byte)flight);
                                        itemData.func_74782_a("Fireworks", (NBTBase)fireworkData);
                                        itemstack.func_77982_d(itemData);
                                        EntityFireworkRocket firework = new EntityFireworkRocket(world, (double)i1 + 0.5, (double)j1 + 0.5, (double)k1 + 0.5, itemstack);
                                        world.func_72838_d((Entity)firework);
                                    }
                                }
                            }
                        }
                    }
                    if (world.func_82737_E() % 20L == 0L) {
                        for (Object element : world.field_73010_i) {
                            EntityPlayer entityplayer = (EntityPlayer)element;
                            LOTRLevelData.sendPlayerLocationsToPlayer(entityplayer, world);
                        }
                    }
                }
            }
            if (world == DimensionManager.getWorld((int)LOTRDimension.UTUMNO.dimensionID) && !world.field_73010_i.isEmpty() && LOTRMod.canSpawnMobs(world)) {
                LOTRSpawnerNPCs.performSpawning(world);
            }
            if (world.field_73011_w instanceof LOTRWorldProvider && world.func_82737_E() % 100L == 0L) {
                LOTRBiomeVariantStorage.performCleanup((WorldServer)world);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (world == null || world.field_72995_K) {
            return;
        }
        if (player != null && player instanceof EntityPlayerMP) {
            EntityPlayerMP entityplayer = (EntityPlayerMP)player;
            if (event.phase == TickEvent.Phase.START && entityplayer.field_71135_a != null && !(entityplayer.field_71135_a instanceof LOTRNetHandlerPlayServer)) {
                entityplayer.field_71135_a = new LOTRNetHandlerPlayServer(MinecraftServer.func_71276_C(), entityplayer.field_71135_a.field_147371_a, entityplayer);
            }
            if (event.phase == TickEvent.Phase.END) {
                EntityItem item;
                List items;
                ItemStack heldItem;
                LOTRLevelData.getData((EntityPlayer)entityplayer).onUpdate(entityplayer, (WorldServer)world);
                NetHandlerPlayServer netHandler = entityplayer.field_71135_a;
                if (netHandler instanceof LOTRNetHandlerPlayServer) {
                    ((LOTRNetHandlerPlayServer)netHandler).update();
                }
                if ((heldItem = entityplayer.func_70694_bm()) != null && (heldItem.func_77973_b() instanceof ItemWritableBook || heldItem.func_77973_b() instanceof ItemEditableBook)) {
                    entityplayer.func_143004_u();
                }
                if (entityplayer.field_71093_bK == LOTRDimension.MIDDLE_EARTH.dimensionID) {
                    items = world.func_72872_a(EntityItem.class, entityplayer.field_70121_D.func_72314_b(16.0, 16.0, 16.0));
                    for (Object obj : items) {
                        EntityItem item1 = (EntityItem)obj;
                        if (item1.func_92059_d() == null || item1.func_92059_d().func_77973_b() != LOTRMod.theOneRing || !item1.func_70027_ad()) continue;
                        int fireX = MathHelper.func_76128_c((double)item1.field_70165_t);
                        int fireY = MathHelper.func_76128_c((double)item1.field_70163_u);
                        int fireZ = MathHelper.func_76128_c((double)item1.field_70161_v);
                        for (int x = -1; x <= 1; ++x) {
                            for (int y = -1; y <= 1; ++y) {
                                for (int z = -1; z <= 1; ++z) {
                                    Block block = world.func_147439_a(fireX + x, fireY + y, fireZ + z);
                                    if (block == Blocks.field_150480_ab) {
                                        world.func_147468_f(fireX + x, fireY + y, fireZ + z);
                                        continue;
                                    }
                                    if (block != Blocks.field_150353_l) continue;
                                    world.func_147449_b(fireX + x, fireY + y, fireZ + z, Blocks.field_150343_Z);
                                }
                            }
                        }
                        BiomeGenBase biome = world.func_72807_a(MathHelper.func_76128_c((double)entityplayer.field_70165_t), MathHelper.func_76128_c((double)entityplayer.field_70161_v));
                        boolean ringRemoved = false;
                        if (biome instanceof LOTRBiomeGenGorgoroth) {
                            for (int i = 0; i < entityplayer.field_71071_by.func_70302_i_(); ++i) {
                                ItemStack itemStack = entityplayer.field_71071_by.func_70301_a(i);
                                if (itemStack == null || itemStack.func_77973_b() != LOTRMod.theOneRing) continue;
                                entityplayer.field_71071_by.func_70299_a(i, null);
                                ringRemoved = true;
                                break;
                            }
                        }
                        if (!ringRemoved && biome instanceof LOTRBiomeGenGorgoroth) continue;
                        item1.func_70106_y();
                        if (ringRemoved) {
                            ItemStack ringStack = new ItemStack(LOTRMod.goldRing);
                            world.func_72838_d((Entity)new EntityItem(world, item1.field_70165_t, item1.field_70163_u, item1.field_70161_v, ringStack));
                            LOTRLevelData.getData((EntityPlayer)entityplayer).addAchievement(LOTRAchievement.destroyRing);
                            continue;
                        }
                        LOTRLevelData.getData((EntityPlayer)entityplayer).addAchievement(LOTRAchievement.burnRing);
                        ItemStack ringStack = item1.func_92059_d();
                        world.func_72838_d((Entity)new EntityItem(world, item1.field_70165_t, item1.field_70163_u, item1.field_70161_v, ringStack));
                    }
                }
                if (entityplayer.field_71093_bK == 0 && LOTRLevelData.madePortal == 0) {
                    items = world.func_72872_a(EntityItem.class, entityplayer.field_70121_D.func_72314_b(16.0, 16.0, 16.0));
                    for (Object obj : items) {
                        item = (EntityItem)obj;
                        if (LOTRLevelData.madePortal != 0 || item.func_92059_d() == null || item.func_92059_d().func_77973_b() != LOTRMod.goldRing || !item.func_70027_ad()) continue;
                        LOTRLevelData.setMadePortal(1);
                        LOTRLevelData.markOverworldPortalLocation(MathHelper.func_76128_c((double)item.field_70165_t), MathHelper.func_76128_c((double)item.field_70163_u), MathHelper.func_76128_c((double)item.field_70161_v));
                        item.func_70106_y();
                        world.func_72876_a((Entity)entityplayer, item.field_70165_t, item.field_70163_u + 3.0, item.field_70161_v, 3.0f, true);
                        LOTREntityPortal portal = new LOTREntityPortal(world);
                        portal.func_70012_b(item.field_70165_t, item.field_70163_u + 3.0, item.field_70161_v, 0.0f, 0.0f);
                        world.func_72838_d((Entity)portal);
                    }
                }
                if (entityplayer.field_71093_bK == 0 || entityplayer.field_71093_bK == LOTRDimension.MIDDLE_EARTH.dimensionID) {
                    items = world.func_72872_a(EntityItem.class, entityplayer.field_70121_D.func_72314_b(16.0, 16.0, 16.0));
                    for (Object obj : items) {
                        int k1;
                        int i1;
                        int[] portalLocation;
                        boolean foundPortalLocation;
                        item = (EntityItem)obj;
                        if (item.func_92059_d() == null) continue;
                        int i = MathHelper.func_76128_c((double)item.field_70165_t);
                        int j = MathHelper.func_76128_c((double)item.field_70163_u);
                        int k = MathHelper.func_76128_c((double)item.field_70161_v);
                        ItemStack itemstack = item.func_92059_d();
                        if ((LOTRLevelData.getData((EntityPlayer)entityplayer).getAlignment(LOTRFaction.LOTHLORIEN) >= 1.0f || LOTRLevelData.getData((EntityPlayer)entityplayer).getAlignment(LOTRFaction.HIGH_ELF) >= 1.0f) && (itemstack.func_77973_b() == Item.func_150898_a((Block)LOTRMod.elanor) || itemstack.func_77973_b() == Item.func_150898_a((Block)LOTRMod.niphredil))) {
                            foundPortalLocation = false;
                            portalLocation = new int[3];
                            for (i1 = i - 2; !foundPortalLocation && i1 <= i + 2; ++i1) {
                                for (k1 = k - 2; !foundPortalLocation && k1 <= k + 2; ++k1) {
                                    if (!((LOTRBlockPortal)LOTRMod.elvenPortal).isValidPortalLocation(world, i1, j, k1, false)) continue;
                                    foundPortalLocation = true;
                                    portalLocation = new int[]{i1, j, k1};
                                }
                            }
                            if (foundPortalLocation) {
                                item.func_70106_y();
                                for (i1 = -1; i1 <= 1; ++i1) {
                                    for (k1 = -1; k1 <= 1; ++k1) {
                                        world.func_147465_d(portalLocation[0] + i1, portalLocation[1], portalLocation[2] + k1, LOTRMod.elvenPortal, 0, 2);
                                    }
                                }
                            }
                        }
                        if (LOTRLevelData.getData((EntityPlayer)entityplayer).getAlignment(LOTRFaction.MORDOR) < 1.0f && LOTRLevelData.getData((EntityPlayer)entityplayer).getAlignment(LOTRFaction.GUNDABAD) < 1.0f && LOTRLevelData.getData((EntityPlayer)entityplayer).getAlignment(LOTRFaction.DOL_GULDUR) < 1.0f || !LOTRMod.isOreNameEqual(itemstack, "bone")) continue;
                        foundPortalLocation = false;
                        portalLocation = new int[3];
                        for (i1 = i - 2; !foundPortalLocation && i1 <= i + 2; ++i1) {
                            for (k1 = k - 2; !foundPortalLocation && k1 <= k + 2; ++k1) {
                                if (!((LOTRBlockPortal)LOTRMod.morgulPortal).isValidPortalLocation(world, i1, j, k1, false)) continue;
                                foundPortalLocation = true;
                                portalLocation = new int[]{i1, j, k1};
                            }
                        }
                        if (!foundPortalLocation) continue;
                        item.func_70106_y();
                        for (i1 = -1; i1 <= 1; ++i1) {
                            for (k1 = -1; k1 <= 1; ++k1) {
                                world.func_147465_d(portalLocation[0] + i1, portalLocation[1], portalLocation[2] + k1, LOTRMod.morgulPortal, 0, 2);
                            }
                        }
                    }
                }
                if ((entityplayer.field_71093_bK == 0 || entityplayer.field_71093_bK == LOTRDimension.MIDDLE_EARTH.dimensionID) && playersInPortals.containsKey(entityplayer)) {
                    int i;
                    List portals = world.func_72872_a(LOTREntityPortal.class, entityplayer.field_70121_D.func_72314_b(8.0, 8.0, 8.0));
                    boolean inPortal = false;
                    for (i = 0; i < portals.size(); ++i) {
                        LOTREntityPortal portal = (LOTREntityPortal)((Object)portals.get(i));
                        if (!portal.field_70121_D.func_72326_a(entityplayer.field_70121_D)) continue;
                        inPortal = true;
                        break;
                    }
                    if (inPortal) {
                        i = (Integer)playersInPortals.get(entityplayer);
                        playersInPortals.put(entityplayer, ++i);
                        if (i >= 100) {
                            int dimension = 0;
                            if (entityplayer.field_71093_bK == 0) {
                                dimension = LOTRDimension.MIDDLE_EARTH.dimensionID;
                            } else if (entityplayer.field_71093_bK == LOTRDimension.MIDDLE_EARTH.dimensionID) {
                                dimension = 0;
                            }
                            if (world instanceof WorldServer) {
                                MinecraftServer.func_71276_C().func_71203_ab().transferPlayerToDimension(entityplayer, dimension, (Teleporter)new LOTRTeleporter(DimensionManager.getWorld((int)dimension), true));
                            }
                            playersInPortals.remove(entityplayer);
                        }
                    } else {
                        playersInPortals.remove(entityplayer);
                    }
                }
                this.updatePlayerInPortal(entityplayer, playersInElvenPortals, (LOTRBlockPortal)LOTRMod.elvenPortal);
                this.updatePlayerInPortal(entityplayer, playersInMorgulPortals, (LOTRBlockPortal)LOTRMod.morgulPortal);
                if (entityplayer.field_71093_bK == LOTRDimension.UTUMNO.dimensionID) {
                    int i = MathHelper.func_76128_c((double)entityplayer.field_70165_t);
                    int j = MathHelper.func_76128_c((double)entityplayer.field_70121_D.field_72338_b);
                    int k = MathHelper.func_76128_c((double)entityplayer.field_70161_v);
                    int range = 32;
                    for (int l = 0; l < 60; ++l) {
                        int meta;
                        Block block;
                        int i1 = i + world.field_73012_v.nextInt(range) - world.field_73012_v.nextInt(range);
                        int j1 = j + world.field_73012_v.nextInt(range) - world.field_73012_v.nextInt(range);
                        int k1 = k + world.field_73012_v.nextInt(range) - world.field_73012_v.nextInt(range);
                        if (LOTRUtumnoLevel.forY(j1) == LOTRUtumnoLevel.ICE) {
                            block = world.func_147439_a(i1, j1, k1);
                            meta = world.func_72805_g(i1, j1, k1);
                            if (block.func_149688_o() == Material.field_151586_h && meta == 0) {
                                world.func_147465_d(i1, j1, k1, Blocks.field_150432_aD, 0, 3);
                            }
                        }
                        if (LOTRUtumnoLevel.forY(j1) != LOTRUtumnoLevel.FIRE) continue;
                        block = world.func_147439_a(i1, j1, k1);
                        meta = world.func_72805_g(i1, j1, k1);
                        if (block.func_149688_o() != Material.field_151586_h || meta != 0) continue;
                        world.func_147465_d(i1, j1, k1, Blocks.field_150350_a, 0, 3);
                        LOTRWorldProviderUtumno.doEvaporateFX(world, i1, j1, k1);
                    }
                }
            }
        }
    }

    private void updatePlayerInPortal(EntityPlayerMP entityplayer, HashMap players, LOTRBlockPortal portalBlock) {
        if ((entityplayer.field_71093_bK == 0 || entityplayer.field_71093_bK == LOTRDimension.MIDDLE_EARTH.dimensionID) && players.containsKey(entityplayer)) {
            boolean inPortal;
            boolean bl = inPortal = entityplayer.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)entityplayer.field_70165_t), MathHelper.func_76128_c((double)entityplayer.field_70121_D.field_72338_b), MathHelper.func_76128_c((double)entityplayer.field_70161_v)) == portalBlock;
            if (inPortal) {
                int i = (Integer)players.get(entityplayer);
                players.put(entityplayer, ++i);
                if (i >= entityplayer.func_82145_z()) {
                    int dimension = 0;
                    if (entityplayer.field_71093_bK == 0) {
                        dimension = LOTRDimension.MIDDLE_EARTH.dimensionID;
                    } else if (entityplayer.field_71093_bK == LOTRDimension.MIDDLE_EARTH.dimensionID) {
                        dimension = 0;
                    }
                    WorldServer newWorld = MinecraftServer.func_71276_C().func_71218_a(dimension);
                    MinecraftServer.func_71276_C().func_71203_ab().transferPlayerToDimension(entityplayer, dimension, portalBlock.getPortalTeleporter(newWorld));
                    players.remove(entityplayer);
                }
            } else {
                players.remove(entityplayer);
            }
        }
    }
}

